package com.mangoslab.nemonicsdktest;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import java.util.ArrayList;

public class PrinterListAdapter extends BaseAdapter {

    private final LayoutInflater layoutInflater;

    private final ArrayList<PrinterListItem> printers = new ArrayList<>();

    public PrinterListAdapter(Context context) {
        layoutInflater = LayoutInflater.from(context);
    }

    @Override
    public int getCount() {
        return printers.size();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public PrinterListItem getItem(int position) {
        return printers.get(position);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        View view = layoutInflater.inflate(R.layout.activity_select_printer_item, null);

        if (position < printers.size()) {
            PrinterListItem printer = printers.get(position);
            TextView printerInformation = view.findViewById(R.id.tv_printer_information);
            printerInformation.setText(String.format("%s(%s)", printer.getName(), printer.getMacAddress()));
        }

        return view;
    }

    public PrinterListItem get(int position) {
        return printers.get(position);
    }

    public void add(PrinterListItem item) {
        if (!isInPrinter(item.getMacAddress())) {
            printers.add(item);
            notifyDataSetChanged();
        }
    }

    public void reset() {
        printers.clear();
        notifyDataSetChanged();
    }

    private Boolean isInPrinter(String macAddress) {
        Boolean result = false;

        for (PrinterListItem item : printers) {
            if (item.getMacAddress().equals(macAddress))
            {
                result = true;
                break;
            }
        }

        return result;
    }
}
