//
//  MGLog.swift
//  FullmoonSdk
//
//  Created by Yeongjae Kim on 2022/07/12.
//

import Foundation
import os.log

@objc(MGLog)
internal class MGLog: NSObject {
    static func d(_ tag: String,_ format: String, _ args: CVarArg...) {
#if DEBUG
        let realFormat = "D: [" + tag + "] " + format
        let contents = NSString(format: realFormat, arguments: getVaList(args))
        NSLog(contents as String)
#endif
    }
    
    static func d(_ tag: String,_ contents: String) {
#if DEBUG
        let realFormat = "D: [" + tag + "] " + contents
        NSLog(realFormat)
#endif
    }
    
    static func e(_ tag: String,_ format: String, _ args: CVarArg...) {
        let realFormat = "E: [" + tag + "] " + format
        let contents = NSString(format: realFormat, arguments: getVaList(args))
        NSLog(contents as String)
    }
    
    static func e(_ tag: String,_ contents: String) {
        let realFormat = "E: [" + tag + "] " + contents
        NSLog(realFormat)
    }
    
    static func i(_ tag: String,_ format: String, _ args: CVarArg...) {
        let realFormat = "I: [" + tag + "] " + format
        let contents = NSString(format: realFormat, arguments: getVaList(args))
        NSLog(contents as String)
    }
    
    static func i(_ tag: String,_ contents: String) {
        let realFormat = "I: [" + tag + "] " + contents
        NSLog(realFormat)
    }
}
