//
//  ViewController.swift
//  NemonicSdkTest
//
//  Created by Yeongjae Kim on 2022/10/21.
//

import UIKit
import DLRadioButton
import NemonicSdk
import ExternalAccessory

class ViewController: UIViewController {
    
    @IBOutlet weak var image: UIImageView!
    
    @IBOutlet weak var selectedPrinterNameLabel: UILabel!
    @IBOutlet weak var selectPrinterButton: UIButton!
    @IBOutlet weak var connectDisconnectButton: UIButton!
    @IBOutlet weak var selectImageButton: UIButton!
    @IBOutlet weak var copiesText: UITextField!
    @IBOutlet weak var printButton: UIButton!
    
    @IBOutlet weak var scrollView: UIScrollView!
    @IBOutlet weak var scrollContentView: UIView!
    
    @IBOutlet weak var lowRadio: DLRadioButton!
    @IBOutlet weak var middleRadio: DLRadioButton!
    @IBOutlet weak var highRadio: DLRadioButton!
    @IBOutlet weak var onlyLastPageCutSwitch: UISwitch!
    @IBOutlet weak var enableDitherSwitch: UISwitch!
    
    @IBOutlet weak var setTemplateButton: UIButton!
    @IBOutlet weak var deleteTemplateButton: UIButton!
    
    @IBOutlet weak var printerStatusLabel: UILabel!
    @IBOutlet weak var paperTypeLabel: UILabel!
    @IBOutlet weak var getDeviceNameLabel: UILabel!
    @IBOutlet weak var getDeviceNameButton: UIButton!
    
    @IBOutlet weak var getBatteryLevelLabel: UILabel!
    @IBOutlet weak var getBatteryLevelButton: UIButton!
    @IBOutlet weak var getBatteryStatusLabel: UILabel!
    @IBOutlet weak var getBatteryStatusButton: UIButton!
    
    @IBOutlet weak var logLabel: UILabel!
    
    
    private var selectedImage: UIImage?
    private var imagePicker: ImagePicker!
    
    private var selectedPrinter: NPrinter?
    private var printerController: NPrinterController?

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        scrollView.contentSize = scrollContentView.frame.size
        
        selectedPrinterNameLabel.text = "No selected printer"
        
        lowRadio.isSelected = true
        
        printerStatusLabel.text = ""
        paperTypeLabel.text = ""
        getDeviceNameLabel.text = ""
        
        getBatteryLevelLabel.text = ""
        getBatteryStatusLabel.text = ""
        
        logLabel.text = ""
        
        addDoneButtonOnKeyboard()
        
        imagePicker = ImagePicker(presentationController: self, delegate: self)
        
        printerController = NPrinterController(self)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        selectedPrinter = SelectPrinterViewController.getSelectedPrinter()
        
        if selectedPrinter != nil 
            && !selectedPrinter!.isEmpty(){
            let name = selectedPrinter!.getName()
            let macAddress = selectedPrinter!.getMacAddress()
            selectedPrinterNameLabel.text = name + "(" + macAddress + ")"
        }
        else {
            selectedPrinterNameLabel.text = "No selected printer"
        }
    }

    @IBAction func actionSelectPrinter(_ sender: Any) {
        let uvc = self.storyboard!.instantiateViewController(withIdentifier: "SelectPrinterVC")
        uvc.modalTransitionStyle = UIModalTransitionStyle.coverVertical
        self.present(uvc, animated: true)
    }
    
    @IBAction func actionConnectDisconnect(_ sender: Any) {
        if connectDisconnectButton.titleLabel?.text == "Connect" {
            connect()
        }
        else {
            disconnect()
        }
    }
    
    @IBAction func actionSelectImage(_ sender: Any) {
        imagePicker.present2(from: sender as! UIButton)
    }
    
    @IBAction func actionPrint(_ sender: Any) {
        let copies = Int(copiesText.text!) ?? 1
        
        let enableDither = enableDitherSwitch.isOn
        if selectedImage != nil {
            let isLastPageCutSwitch = onlyLastPageCutSwitch.isOn
            
            let lowSelected = lowRadio.isSelected
            let middleSelected = middleRadio.isSelected
            
            Thread.init() {
                let printInfo = NPrintInfo(printer: self.selectedPrinter ?? NPrinter(), image: self.selectedImage!)
                    .setCopies(copies)
                    .setEnableLastPageCut(isLastPageCutSwitch)
                    .setEnableDither(false)
                    .setEnableDither(enableDither)
                
                if (lowSelected) {
                    _ = printInfo.setPrintQuality(NPrintQuality.lowFast)
                }
                else if (middleSelected) {
                    _ = printInfo.setPrintQuality(NPrintQuality.middle)
                }
                else {
                    _ = printInfo.setPrintQuality(NPrintQuality.highSlow)
                }
                
                let result = self.printerController?.print(printInfo)
                self.processEtcResult(result)
            }.start()
        }
        else {
            setResult("No selected iamge")
        }
    }
    
    @IBAction func actionSetTemplate(_ sender: Any) {
        if selectedImage != nil {
            let result = printerController?.setTemplate(selectedImage!, withPrint: true, enableDither: enableDitherSwitch.isOn)
            processEtcResult(result)
        }
        else {
            setResult("No selected iamge")
        }
    }
    
    @IBAction func actionDeleteTemplate(_ sender: Any) {
        let result = printerController?.clearTemplate()
        
        processEtcResult(result)
    }
    
    @IBAction func actionPrinterStatus(_ sender: Any) {
        printerStatusLabel.text = ""
        
        let result = printerController?.getPrinterStatus()
        
        switch result {
        case NPrinterStatus.ok.rawValue:
            printerStatusLabel.text = "ok"
            setResult("Printer status is ok")
        case NPrinterStatus.outOfPaper.rawValue:
            printerStatusLabel.text = "Out of paper"
            setResult("Printer status is out of paper")
        case NPrinterStatus.coverOpened.rawValue:
            printerStatusLabel.text = "Cover opened"
            setResult("Printer status is cover opened")
        case NPrinterStatus.overheat.rawValue:
            printerStatusLabel.text = "Over heat"
            setResult("Printer status is over heat")
        case NPrinterStatus.paperJam.rawValue:
            printerStatusLabel.text = "Paper jam"
            setResult("Printer status is paper jam")
        default:
            processEtcResult(result)
        }
    }
    
    @IBAction func actionPaperType(_ sender: Any) {
        paperTypeLabel.text = ""
        
        let result = printerController?.getCartridgeType()
        
        switch result {
        case NCartridgeType.white.rawValue:
            paperTypeLabel.text = "White"
            setResult("Paper type is white")
        case NCartridgeType.yellow.rawValue:
            paperTypeLabel.text = "Yellow"
            setResult("Paper type is yellow")
        case NCartridgeType.green.rawValue:
            paperTypeLabel.text = "Green"
            setResult("Paper type is green")
        case NCartridgeType.blue.rawValue:
            paperTypeLabel.text = "Blue"
            setResult("Paper type is blue")
        case NCartridgeType.pink.rawValue:
            paperTypeLabel.text = "Pink"
            setResult("Paper type is pink")
        case NCartridgeType.l1.rawValue:
            paperTypeLabel.text = "L1"
            setResult("Paper type is l1")
        case NCartridgeType.l2.rawValue:
            paperTypeLabel.text = "L2"
            setResult("Paper type is l2")
        case NCartridgeType.l3.rawValue:
            paperTypeLabel.text = "L3"
            setResult("Paper type is l3")
        case NCartridgeType.l4.rawValue:
            paperTypeLabel.text = "L4"
            setResult("Paper type is l4")
        case NCartridgeType.l5.rawValue:
            paperTypeLabel.text = "L5"
            setResult("Paper type is l5")
        case NCartridgeType.l6.rawValue:
            paperTypeLabel.text = "L6"
            setResult("Paper type is l6")
        case NCartridgeType.l7.rawValue:
            paperTypeLabel.text = "L7"
            setResult("Paper type is l7")
        case NCartridgeType.l8.rawValue:
            paperTypeLabel.text = "L8"
            setResult("Paper type is l8")
        case NCartridgeType.question.rawValue:
            paperTypeLabel.text = "?"
            setResult("Paper type is ?")
        case NCartridgeType.n.rawValue:
            paperTypeLabel.text = "N"
            setResult("Paper type is N")
        default:
            processEtcResult(result)
        }
    }
    
    @IBAction func actionGetDeviceName(_ sender: Any) {
        let result = printerController?.getPrinterName()
        
        if result!.getResult() == NResult.ok.rawValue {
            getDeviceNameLabel.text = result!.getValue()
            setResult("Success")
        }
        else {
            processEtcResult(result!.getResult())
        }
    }
    
    @IBAction func actionGetBatteryLevel(_ sender: Any) {
        getBatteryLevelLabel.text = ""
        let result = printerController?.getBatteryLevel()
        
        if result != nil {
            if result! >= 0 {
                getBatteryLevelLabel.text = String.init(format:"%d", result!)
            }
            else {
                processEtcResult(result)
            }
        }
        else {
            setResult("Result is nil")
        }
    }
    
    @IBAction func actionGetBatteryStatus(_ sender: Any) {
        getBatteryStatusLabel.text = ""
        let result = printerController?.getBatteryStatus()
        
        switch result {
        case NBatteryStatus.noCharging.rawValue:
            getBatteryStatusLabel.text = "No charging"
            setResult("No charging")
        case NBatteryStatus.lowNoCharging.rawValue:
            getBatteryStatusLabel.text = "Low and No charging"
            setResult("Low and No charging")
        case NBatteryStatus.charging.rawValue:
            getBatteryStatusLabel.text = "Charging"
            setResult("Charging")
        case NBatteryStatus.lowCharging.rawValue:
            getBatteryStatusLabel.text = "Low and Charging"
            setResult("Low and Charging")
        default:
            processEtcResult(result)
        }
    }
    
    private func connect() {
        if selectedPrinter != nil 
            && !selectedPrinter!.isEmpty() {
            
            Thread.init() {
                let result = self.printerController?.connect(self.selectedPrinter!)
                
                if result != nil {
                    if result == NResult.ok.rawValue {
                        self.setResult("Connect success")
                        DispatchQueue.main.async {
                            self.connectDisconnectButton.setTitle("Disconnect", for: UIControl.State.normal)
                        }
                    }
                    else {
                        self.setResult(String.init(format: "Connect failed(%d)", result!))
                    }
                }
                else {
                    self.setResult("Result is nil")
                }
            }.start()
        }
        else {
            setResult("No selected printer")
        }
    }
    
    private func disconnect() {
        printerController?.disconnect()
        DispatchQueue.main.async {
            self.connectDisconnectButton.setTitle("Connect", for: UIControl.State.normal)
        }
    }
    
    private func processEtcResult(_ result: Int?) {
        if result != nil {
            switch result {
            case NResult.ok.rawValue:
                setResult("Success")
            case NResult.notConnected.rawValue:
                setResult("Not connected")
            case NResult.timeout.rawValue:
                setResult("Timeout")
            case NResult.unknown.rawValue:
                setResult("Unknown")
            case NResult.invalidParameter.rawValue:
                setResult("Not valied parameter")
            case NResult.notMatchedPrinterType.rawValue:
                setResult("Not matched printer type")
            default:
                setResult("%d", result!)
            }
        }
        else {
            setResult("Result is nil")
        }
    }
    
    private func setResult(_ result: String) {
        makeToast(result)
        setLog(result)
    }
    
    private func setResult(_ format: String, _ args: CVarArg...) {
        let result = String.init(format: format, args)
        makeToast(result)
        setLog(result)
    }
    
    private func makeToast(_ content: String) {
        DispatchQueue.main.async {
            self.view.makeToast(content)
        }
    }
    
    private func setLog(_ log: String) {
        setLog(log, isAdd: false)
    }
    
    private func setLog(_ log: String, isAdd: Bool) {
        DispatchQueue.main.async {
            let formatter = DateFormatter()
            formatter.dateFormat = "yyyy-MM-dd HH:mm:ss "
            let dateLog = formatter.string(from: Date()) + log
            
            if isAdd {
                let oldLog = self.logLabel.text
                if oldLog != nil {
                    self.logLabel.text = oldLog! + "\n" + dateLog
                }
                else {
                    self.logLabel.text = dateLog
                }
            }
            else {
                self.logLabel.text = dateLog
            }
        }
    }
}

extension ViewController: NPrinterControllerDelegate {
    func disconnected() {
        DispatchQueue.main.async {
            self.connectDisconnectButton.setTitle("Connect", for: UIControl.State.normal)
        }
    }
    
    func printProgress(index: Int, total: Int, result: Int) {
    }
    
    func printComplete(result: Int) {
    }
}

extension ViewController: ImagePickerDelegate {
    func didSelect(image: UIImage?) {
        if image != nil {
            self.image.image = image
            selectedImage = image
        }
    }
}

extension ViewController: UITextFieldDelegate {
    func hideKeyboard() {
        let tap = UITapGestureRecognizer(target: self, action: #selector(dismissKeyboard))
        view.addGestureRecognizer(tap)
    }
    
    @objc func dismissKeyboard() {
        view.endEditing(true)
    }
    
    func addDoneButtonOnKeyboard() {
        let doneToolbar: UIToolbar = UIToolbar(frame: CGRect.init(x: 0, y: 0, width: UIScreen.main.bounds.width, height: 50))
        doneToolbar.barStyle = .default

        let flexSpace = UIBarButtonItem(barButtonSystemItem: .flexibleSpace, target: nil, action: nil)
        let done: UIBarButtonItem = UIBarButtonItem(title: "Done", style: .done, target: self, action: #selector(self.doneButtonAction))

        let items = [flexSpace, done]
        doneToolbar.items = items
        doneToolbar.sizeToFit()

        copiesText.inputAccessoryView = doneToolbar
    }
    
    @objc func doneButtonAction(){
        copiesText.resignFirstResponder()
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        view.endEditing(true)
    }
}
