// NPrinterScanControllerModule.java

package com.nemonicsdk;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;

import com.mangoslab.nemonicsdk.INPrinterScanControllerCallback;
import com.mangoslab.nemonicsdk.NPrinter;
import com.mangoslab.nemonicsdk.NPrinterScanController;

public class NPrinterScanControllerModule extends ReactContextBaseJavaModule implements INPrinterScanControllerCallback {

    private ReactApplicationContext reactContext;

    private NPrinterScanController printerScanController = null;

    public NPrinterScanControllerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        printerScanController = new NPrinterScanController(reactContext, this);
    }

    @Override
    public String getName() {
        return "NPrinterScanControllerModule";
    }

    @ReactMethod
    public void startScan(Promise promise) {
        int result = printerScanController.startScan();
        promise.resolve(result);
    }

    @ReactMethod
    public void stopScan() {
        printerScanController.stopScan();
    }

    @Override
    public void deviceFound(NPrinter printer) {
        WritableMap params = Arguments.createMap();
        params.putString("name", printer.getName());
        params.putString("macAddress", printer.getMacAddress());
        params.putInt("type", printer.getType().getValue());
        reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit("deviceFound", params);
    }
}
