"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NPrinterScanController = void 0;
var _reactNative = require("react-native");
var _NPrinter = require("./NPrinter.js");
const LINKING_ERROR = `The package 'react-native-nemonic-sdk' doesn't seem to be linked. Make sure: \n\n` + _reactNative.Platform.select({
  ios: "- You have run 'pod install'\n",
  default: ''
}) + '- You rebuilt the app after installing the package\n' + '- You are not using Expo Go\n';
const NPrinterScanControllerModule = _reactNative.NativeModules.NPrinterScanControllerModule ? _reactNative.NativeModules.NPrinterScanControllerModule : new Proxy({}, {
  get() {
    throw new Error(LINKING_ERROR);
  }
});
class NPrinterScanController {
  constructor(callback) {
    NPrinterScanController.callback = callback;
    this.eventEmitter = new _reactNative.NativeEventEmitter(NPrinterScanControllerModule);
  }
  startScan() {
    this.registerEvent();
    return NPrinterScanControllerModule.startScan();
  }
  stopScan() {
    NPrinterScanControllerModule.stopScan();
    this.unregisterEvent();
  }
  deviceFound(params) {
    var name = params.name;
    var macAddress = params.macAddress;
    var type = params.type;
    var printer = new _NPrinter.NPrinter();
    printer.setName(name);
    printer.setMacAddress(macAddress);
    printer.setType(type);
    console.log(name + '(' + macAddress + ')');
    NPrinterScanController.callback.deviceFound(printer);
  }
  registerEvent() {
    this.eventDeviceFoundListener = this.eventEmitter.addListener('deviceFound', this.deviceFound);
  }
  unregisterEvent() {
    this.eventDeviceFoundListener?.remove();
  }
}
exports.NPrinterScanController = NPrinterScanController;
//# sourceMappingURL=NPrinterScanController.js.map