/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 */

import React from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createNativeStackNavigator, NativeStackNavigationProp } from '@react-navigation/native-stack';
import MainScreen from './src/screens/MainScreen';
import SelectPrinterScreen from './src/screens/SelectPrinterScreen';
import Toast from 'react-native-toast-message';


type RootStackParamList = {
  Main: undefined;
  SelectPrinter: undefined;
}

const Stack = createNativeStackNavigator<RootStackParamList>();

const RootNavigator = () => {
  return (
    <NavigationContainer>
      <Stack.Navigator initialRouteName="Main">
        <Stack.Screen
          name="Main"
          component={MainScreen}
          options={{ headerShown: false }}
        />
        <Stack.Screen
          name="SelectPrinter"
          component={SelectPrinterScreen}
        />
      </Stack.Navigator>
      <Toast />
    </NavigationContainer>
  );
}

export type NavigationProp = NativeStackNavigationProp<RootStackParamList>;

function App(): React.JSX.Element {
  return RootNavigator();
}

export default App;
