import NemonicSdk

@objc(NPrinterScanControllerModule)
class NPrinterScanControllerModule: RCTEventEmitter {

    private var printerScanController: NPrinterScanController?

    @objc(init)
    override init() {
        super.init()
        printerScanController = NPrinterScanController(self)
    }

    @objc(startScan:withRejecter:)
    func startScan(resolve:RCTPromiseResolveBlock, reject:RCTPromiseRejectBlock) -> Void {
        let result = printerScanController?.startScan()

        resolve(result)
    }

    @objc(stopScan)
    func stopScan() -> Void {
        printerScanController?.stopScan()
    }

    @objc
    override static func requiresMainQueueSetup() -> Bool {
        return true
    }
    
    @objc
    override func supportedEvents() -> [String]! {
        return [ "deviceFound" ];
    }
}

extension NPrinterScanControllerModule: NPrinterScanControllerDelegate {
    func deviceFound(_ printer: NPrinter) {
        var params = Dictionary<String, Any>()
        params["name"] = printer.getName()
        params["macAddress"] = printer.getMacAddress()
        params["type"] = printer.getType().rawValue
        sendEvent(withName: "deviceFound", body: params)
    }
}
