"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NPrintInfo = void 0;
class NPrintInfo {
  images = [];
  imageUrls = [];
  quality = 0; // NPrintQuality

  copies = 1;
  isLastPageCut = true;
  enableDither = true;
  isCheckPrinterStatus = true;
  isCheckCartridgeType = true;
  isCheckPower = true;
  addImage(image) {
    this.images = [...this.images, image];
    return this;
  }
  addImageWithUint8Array(image) {
    let data = [];

    // for (let i = 0; i < image.length; i++) {
    //     data = [...data, image[i] as number]
    // }

    for (let i = 0; i < image.length; i++) {
      data[i] = image[i];
    }
    return this.addImage(data);
  }
  clearImages() {
    this.images = [];
  }
  getImages() {
    return this.images;
  }
  addImageUrl(url) {
    this.imageUrls = [...this.imageUrls, url];
    return this;
  }
  clearImageUrls() {
    this.imageUrls = [];
  }
  getImageUrls() {
    return this.imageUrls;
  }
  setPrintQulity(quality) {
    this.quality = quality;
    return this;
  }
  getPrintQuality() {
    return this.quality;
  }
  setCopies(copies) {
    this.copies = copies;
    return this;
  }
  getCopies() {
    return this.copies;
  }
  setEnableLastPageCut(enable) {
    this.isLastPageCut = enable;
    return this;
  }
  isLastPageCutEnable() {
    return this.isLastPageCut;
  }
  setEnableDither(enable) {
    this.enableDither = enable;
    return this;
  }
  isEnableDither() {
    return this.enableDither;
  }
  setEnableCheckPrinterStatus(enable) {
    this.isCheckPrinterStatus = enable;
    return this;
  }
  isCheckPrinterStatusEnable() {
    return this.isCheckPrinterStatus;
  }
  setEnableCheckCartridgeType(enable) {
    this.isCheckCartridgeType = enable;
    return this;
  }
  isCheckCartridgeTypeEnable() {
    return this.isCheckCartridgeType;
  }
  setEnableCheckPower(enable) {
    this.isCheckPower = enable;
    return this;
  }
  isCheckPowerEnable() {
    return this.isCheckPower;
  }
}
exports.NPrintInfo = NPrintInfo;
//# sourceMappingURL=NPrintInfo.js.map