"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NResult = void 0;
class NResult {
  static OK = 0;
  static TIMEOUT = -64;
  static CANCELED = -65;
  static BATTERY_LOW = -70;
  static BATTERY_NEED_CHARGE = -71;
  static BATTERY_LOW_OR_NO_CHARGE = -72;
  static PAPER_NOT_MATCHED = -80;
  static UNAVAILABLE_CARTRIDGE = -81;
  static NEED_UPDATE_FIRMWARE = -90;
  static BLUETOOTH_UNSUPPORTED = -100;
  static BLUETOOTH_DISABLED = -101;
  static BLUETOOTH_NO_PERMISSION = -102;
  static BLUETOOTH_RESETTING = -103; // Only iOS
  static CANCELED_OR_BLUETOOTH_DISABLED = -104; // Only iOS
  static BBLUETOOTH_UNKNOWN = -105; // Only iOS
  static LOCATION_NO_PERMISSION = -110; // Only Android
  static LOCATION_DISABLED = -111; // Only Android
  static SCAN_FAILED = -200;
  static NO_SELECTED_PRINTER = -300;
  static NOT_CONNECTED = -301;
  static ALREADY_CONNECTED = -302;
  static NOT_FOUND = -303; // Only iOS
  static NOT_CONNECTABLE = -304; // Only iOS
  static SOCKET_ERROR = -305; // Only Android
  static CONNECT_ERROR = -306;
  static CONNECT_FAILED = -307;
  static SESSION_ERROR = -308;
  static CONNECT_SERVICE_NOT_FOUND = -309;
  static CONNECT_UNSUPPORTED_MODE = -310;
  static IO_RECEIVE_ERROR = -400;
  static IO_SEND_ERROR = -401;
  static SEND_FAILED = -402;
  static UNKNOWN = -500;
  static INVALID_PARAMETER = -501;
  static NOT_MATCHED_PRINTER_TYPE = -502;
  static NO_CALLBACK = -503;
  static NOT_MATCHED_COMMAND_RESULT_FORMAT = -504;
  static INVALID_PRINTER_NAME = -505;
  static INVALID_PRINTER_RESULT = -506;
  static PRINTER_RESULT_FAILED = -507;
  static UNSUPPORTED_DEVICE = -508;
  static EXCEED_MAX_SIZE = -900; // Only React Native 24.12.20(Max size: 196603 per one image)
}
exports.NResult = NResult;
//# sourceMappingURL=NResult.js.map