"use strict";

import { NativeEventEmitter, NativeModules, Platform } from 'react-native';
import { NResultString } from "./constants/NResultString.js";
import { NResult } from "./constants/NResult.js";
const LINKING_ERROR = `The package 'react-native-nemonic-sdk' doesn't seem to be linked. Make sure: \n\n` + Platform.select({
  ios: "- You have run 'pod install'\n",
  default: ''
}) + '- You rebuilt the app after installing the package\n' + '- You are not using Expo Go\n';
const NPrinterControllerModule = NativeModules.NPrinterControllerModule ? NativeModules.NPrinterControllerModule : new Proxy({}, {
  get() {
    throw new Error(LINKING_ERROR);
  }
});
export class NPrinterController {
  static MAX_IMAGE_SIZE = 196603;
  constructor() {
    this.eventEmitter = new NativeEventEmitter(NPrinterControllerModule);
  }
  setCallback(callback) {
    NPrinterController.callback = callback;
  }
  getBleConnectDelayOffsetForAndroid() {
    return NPrinterControllerModule.getBleConnectDelayOffset();
  }
  setBleConnectDelayOffsetForAndroid(msec) {
    const params = {
      'msec': msec
    };
    NPrinterControllerModule.setBleConnectDelayOffset(params);
  }
  getBleSendRetryDelayOffsetForAndroid() {
    return NPrinterControllerModule.getBleSendRetryDelayOffset();
  }
  setBleSendRetryDelayOffsetForAndroid(msec) {
    const params = {
      'msec': msec
    };
    NPrinterControllerModule.setBleSendRetryDelayOffset(params);
  }
  getDefaultConnectDelayForiOS() {
    return NPrinterControllerModule.getDefaultConnectDelay();
  }
  getConnectDelayForiOS() {
    return NPrinterControllerModule.getConnectDelay();
  }
  setConnectDelayForiOS(msec) {
    const params = {
      'msec': msec
    };
    NPrinterControllerModule.setConnectDelay(params);
  }
  async connect(printer, queueLabel = '') {
    this.registerEvent();
    const params = {
      'name': printer.getName(),
      'macAddress': printer.getMacAddress(),
      'type': printer.getType(),
      'queueLabel': queueLabel
    };
    var result = await NPrinterControllerModule.connect(params);
    if (result != 0) {
      this.unregisterEvent();
    }
    return result;
  }
  disconnect() {
    this.unregisterEvent();
    NPrinterControllerModule.disconnect();
  }
  getConnectState() {
    return NPrinterControllerModule.getConnectState();
  }
  cancel() {
    NPrinterControllerModule.cancel();
  }
  setPrintTimeout(enableAuto, manualTime) {
    const params = {
      enableAuto: enableAuto,
      manualTime: manualTime
    };
    NPrinterControllerModule.setPrintTimeout(params);
  }
  print(printInfo) {
    let images = printInfo.getImages();
    for (const image of images) {
      if (image.length > NPrinterController.MAX_IMAGE_SIZE) {
        return new Promise(resolve => {
          resolve(NResult.EXCEED_MAX_SIZE);
        });
      }
    }
    const params = {
      images: images,
      imageUrls: printInfo.getImageUrls(),
      quality: printInfo.getPrintQuality(),
      copies: printInfo.getCopies(),
      isLastPageCut: printInfo.isLastPageCutEnable(),
      enableDither: printInfo.isEnableDither(),
      isCheckPrinterStatus: printInfo.isCheckCartridgeTypeEnable(),
      isCheckCartridgeType: printInfo.isCheckCartridgeTypeEnable(),
      isCheckPower: printInfo.isCheckPowerEnable()
    };
    return NPrinterControllerModule.print(params);
  }
  setTemplate(image, withPrint, enableDither) {
    if (image.length > NPrinterController.MAX_IMAGE_SIZE) {
      return new Promise(resolve => {
        resolve(NResult.EXCEED_MAX_SIZE);
      });
    }
    const params = {
      image: image,
      withPrint: withPrint,
      enableDither: enableDither
    };
    return NPrinterControllerModule.setTemplate(params);
  }
  setTemplateWithUint8Array(image, withPrint, enableDither) {
    let data = [];
    for (let i = 0; i < image.length; i++) {
      data[i] = image[i];
    }
    return this.setTemplate(data, withPrint, enableDither);
  }
  setTemplateWithUrl(imageUrl, withPrint, enableDither) {
    const params = {
      imageUrl: imageUrl,
      withPrint: withPrint,
      enableDither: enableDither
    };
    return NPrinterControllerModule.setTemplateWithUrl(params);
  }
  clearTemplate() {
    return NPrinterControllerModule.clearTemplate();
  }
  getPrinterStatus() {
    return NPrinterControllerModule.getPrinterStatus();
  }
  getCartridgeType() {
    return NPrinterControllerModule.getCartridgeType();
  }
  async getPrinterName() {
    let resultParams = await NPrinterControllerModule.getPrinterName();
    let result = this.getResultString(resultParams);
    return result;
  }
  getBatteryLevel() {
    return NPrinterControllerModule.getBatteryLevel();
  }
  getBatteryStatus() {
    return NPrinterControllerModule.getBatteryStatus();
  }
  disconnected() {
    NPrinterController.callback?.disconnected();
  }
  printProgress(params) {
    var index = params.index;
    var total = params.total;
    var result = params.result;
    NPrinterController.callback?.printProgress(index, total, result);
  }
  printComplete(params) {
    var result = params.result;
    NPrinterController.callback?.printComplete(result);
  }
  registerEvent() {
    this.eventDisconnectedListener = this.eventEmitter.addListener('disconnected', this.disconnected);
    this.eventPrintProgressListener = this.eventEmitter.addListener('printProgress', this.printProgress);
    this.eventPrintCompleteListener = this.eventEmitter.addListener('printComplete', this.printComplete);
  }
  unregisterEvent() {
    this.eventDisconnectedListener?.remove();
    this.eventPrintProgressListener?.remove();
    this.eventPrintCompleteListener?.remove();
  }
  getResultString(params) {
    let result = params.result;
    let value = params.value;
    let resultString = new NResultString();
    resultString.setResult(result);
    resultString.setValue(value);
    return resultString;
  }
}
//# sourceMappingURL=NPrinterController.js.map