"use strict";

import { NativeEventEmitter, NativeModules, Platform } from 'react-native';
import { NPrinter } from "./NPrinter.js";
const LINKING_ERROR = `The package 'react-native-nemonic-sdk' doesn't seem to be linked. Make sure: \n\n` + Platform.select({
  ios: "- You have run 'pod install'\n",
  default: ''
}) + '- You rebuilt the app after installing the package\n' + '- You are not using Expo Go\n';
const NPrinterScanControllerModule = NativeModules.NPrinterScanControllerModule ? NativeModules.NPrinterScanControllerModule : new Proxy({}, {
  get() {
    throw new Error(LINKING_ERROR);
  }
});
export class NPrinterScanController {
  constructor(callback) {
    NPrinterScanController.callback = callback;
    this.eventEmitter = new NativeEventEmitter(NPrinterScanControllerModule);
  }
  startScan() {
    this.registerEvent();
    return NPrinterScanControllerModule.startScan();
  }
  stopScan() {
    NPrinterScanControllerModule.stopScan();
    this.unregisterEvent();
  }
  deviceFound(params) {
    var name = params.name;
    var macAddress = params.macAddress;
    var type = params.type;
    var printer = new NPrinter();
    printer.setName(name);
    printer.setMacAddress(macAddress);
    printer.setType(type);
    console.log(name + '(' + macAddress + ')');
    NPrinterScanController.callback.deviceFound(printer);
  }
  registerEvent() {
    this.eventDeviceFoundListener = this.eventEmitter.addListener('deviceFound', this.deviceFound);
  }
  unregisterEvent() {
    this.eventDeviceFoundListener?.remove();
  }
}
//# sourceMappingURL=NPrinterScanController.js.map