import type { NPrinter } from './NPrinter';
import type { INPrinterControllerCallback } from './INPrinterControllerCallback';
import type { NPrintInfo } from './NPrintInfo';
import { NResultString } from './constants/NResultString';
export declare class NPrinterController {
    static MAX_IMAGE_SIZE: number;
    private static callback?;
    private eventEmitter;
    private eventDisconnectedListener?;
    private eventPrintProgressListener?;
    private eventPrintCompleteListener?;
    constructor();
    setCallback(callback?: INPrinterControllerCallback): void;
    getBleConnectDelayOffsetForAndroid(): Promise<number>;
    setBleConnectDelayOffsetForAndroid(msec: number): void;
    getBleSendRetryDelayOffsetForAndroid(): Promise<number>;
    setBleSendRetryDelayOffsetForAndroid(msec: number): void;
    getDefaultConnectDelayForiOS(): Promise<number>;
    getConnectDelayForiOS(): Promise<number>;
    setConnectDelayForiOS(msec: number): void;
    connect(printer: NPrinter, queueLabel?: string): Promise<number>;
    disconnect(): void;
    getConnectState(): Promise<number>;
    cancel(): void;
    setPrintTimeout(enableAuto: boolean, manualTime: number): void;
    print(printInfo: NPrintInfo): Promise<number>;
    setTemplate(image: number[], withPrint: boolean, enableDither: boolean): Promise<number>;
    setTemplateWithUint8Array(image: Uint8Array, withPrint: boolean, enableDither: boolean): Promise<number>;
    setTemplateWithUrl(imageUrl: string, withPrint: boolean, enableDither: boolean): Promise<number>;
    clearTemplate(): Promise<number>;
    getPrinterStatus(): Promise<number>;
    getCartridgeType(): Promise<number>;
    getPrinterName(): Promise<NResultString>;
    getBatteryLevel(): Promise<number>;
    getBatteryStatus(): Promise<number>;
    private disconnected;
    private printProgress;
    private printComplete;
    private registerEvent;
    private unregisterEvent;
    private getResultString;
}
//# sourceMappingURL=NPrinterController.d.ts.map