
export class NPrintInfo {

    private images: number[][] = []
    private imageUrls: string[] = []

    private quality = 0         // NPrintQuality

    private copies = 1
    private isLastPageCut = true
    private enableDither = true

    private isCheckPrinterStatus = true
    private isCheckCartridgeType = true
    private isCheckPower = true

    public addImage(image: number[]): NPrintInfo {
        this.images = [...this.images, image]
        return this
    }

    public addImageWithUint8Array(image: Uint8Array): NPrintInfo {
        let data: number[] = []

        // for (let i = 0; i < image.length; i++) {
        //     data = [...data, image[i] as number]
        // }

        for (let i = 0; i < image.length; i++) {
            data[i] = image[i] as number
        }

        return this.addImage(data)
    }

    public clearImages() {
        this.images = []
    }

    public getImages(): number[][] {
        return this.images
    }

    public addImageUrl(url: string): NPrintInfo {
        this.imageUrls = [...this.imageUrls, url]
        return this
    }

    public clearImageUrls() {
        this.imageUrls = []
    }

    public getImageUrls(): string[] {
        return this.imageUrls
    }

    public setPrintQulity(quality: number): NPrintInfo {
        this.quality = quality
        return this
    }

    public getPrintQuality(): number {
        return this.quality
    }

    public setCopies(copies: number): NPrintInfo {
        this.copies = copies
        return this
    }

    public getCopies(): number {
        return this.copies
    }

    public setEnableLastPageCut(enable: boolean): NPrintInfo {
        this.isLastPageCut = enable
        return this
    }

    public isLastPageCutEnable(): boolean {
        return this.isLastPageCut
    }

    public setEnableDither(enable: boolean): NPrintInfo {
        this.enableDither = enable
        return this
    }

    public isEnableDither(): boolean {
        return this.enableDither
    }

    public setEnableCheckPrinterStatus(enable: boolean): NPrintInfo {
        this.isCheckPrinterStatus = enable
        return this
    }

    public isCheckPrinterStatusEnable(): boolean {
        return this.isCheckPrinterStatus
    }

    public setEnableCheckCartridgeType(enable: boolean): NPrintInfo {
        this.isCheckCartridgeType = enable
        return this
    }

    public isCheckCartridgeTypeEnable(): boolean {
        return this.isCheckCartridgeType
    }

    public setEnableCheckPower(enable: boolean): NPrintInfo {
        this.isCheckPower = enable
        return this
    }

    public isCheckPowerEnable(): boolean {
        return this.isCheckPower
    }
}
