
export enum NCartridgeType {
    none = -1,
    white = 0,
    yellow = 1,
    green = 2,
    blue = 3,
    pink = 7,
    l1 = 13,
    l2 = 12,
    l3 = 10,
    l4 = 6,
    l5 = 8,
    l6 = 5,
    l7 = 9,
    l8 = 11,
    m1 = 101,
    m2 = 102,
    m3 = 103,
    m4 = 104,
    m5 = 105,
    m6 = 106,
    m7 = 107,
    m8 = 108,
    question = 4,
    n = 14
}

export namespace NCartridgeType {
    export function isValidCartridge(type: NCartridgeType): boolean {
        switch (type) {
            case NCartridgeType.white:
            case NCartridgeType.yellow:
            case NCartridgeType.green:
            case NCartridgeType.blue:
            case NCartridgeType.pink:
            case NCartridgeType.l1:
            case NCartridgeType.l2:
            case NCartridgeType.l3:
            case NCartridgeType.l4:
            case NCartridgeType.l5:
            case NCartridgeType.l6:
            case NCartridgeType.l7:
            case NCartridgeType.l8:
            case NCartridgeType.m1:
            case NCartridgeType.m2:
            case NCartridgeType.m3:
            case NCartridgeType.m4:
            case NCartridgeType.m5:
            case NCartridgeType.m6:
            case NCartridgeType.m7:
            case NCartridgeType.m8:
            case NCartridgeType.n:
                return true
        }

        return false
    }

    export function isMiniCartridge(type: NCartridgeType): boolean {
        switch (type) {
            case NCartridgeType.m1:
            case NCartridgeType.m2:
            case NCartridgeType.m3:
            case NCartridgeType.m4:
            case NCartridgeType.m5:
            case NCartridgeType.m6:
            case NCartridgeType.m7:
            case NCartridgeType.m8:
                return true
        }

        return false
    }

    export function isLabelCartridge(type: NCartridgeType): boolean {
        switch (type) {
            case NCartridgeType.l1:
            case NCartridgeType.l2:
            case NCartridgeType.l3:
            case NCartridgeType.l4:
            case NCartridgeType.l5:
            case NCartridgeType.l6:
            case NCartridgeType.l7:
            case NCartridgeType.l8:
                return true
        }

        return false
    }

    export function isStickyCartridge(type: NCartridgeType): boolean {
        switch (type) {
            case NCartridgeType.white:
            case NCartridgeType.yellow:
            case NCartridgeType.green:
            case NCartridgeType.blue:
            case NCartridgeType.pink:
            case NCartridgeType.l1:
            case NCartridgeType.l2:
            case NCartridgeType.l3:
            case NCartridgeType.l4:
            case NCartridgeType.l5:
            case NCartridgeType.l6:
            case NCartridgeType.l7:
            case NCartridgeType.l8:
            case NCartridgeType.m1:
            case NCartridgeType.m2:
            case NCartridgeType.m3:
            case NCartridgeType.m4:
            case NCartridgeType.m5:
            case NCartridgeType.m6:
            case NCartridgeType.m7:
            case NCartridgeType.m8:
            case NCartridgeType.n:
                return true
        }

        return false
    }

    export function getCartridgeName(type: NCartridgeType): string {
        switch (type) {
            case NCartridgeType.white:
                return "W"
            case NCartridgeType.yellow:
                return "Y"
            case NCartridgeType.green:
                return "G"
            case NCartridgeType.blue:
                return "B"
            case NCartridgeType.pink:
                return "P"
            case NCartridgeType.l1:
                return "L1"
            case NCartridgeType.l2:
                return "L2"
            case NCartridgeType.l3:
                return "L3"
            case NCartridgeType.l4:
                return "L4"
            case NCartridgeType.l5:
                return "L5"
            case NCartridgeType.l6:
                return "L6"
            case NCartridgeType.l7:
                return "L7"
            case NCartridgeType.l8:
                return "L8"
            case NCartridgeType.m1:
                return "m1"
            case NCartridgeType.m2:
                return "m2"
            case NCartridgeType.m3:
                return "m3"
            case NCartridgeType.m4:
                return "m4"
            case NCartridgeType.m5:
                return "m5"
            case NCartridgeType.m6:
                return "m6"
            case NCartridgeType.m7:
                return "m7"
            case NCartridgeType.m8:
                return "m8"
            case NCartridgeType.question:
                return "?"
            case NCartridgeType.n:
                return "n"
            default:
                return "X"
        }
    }

    export function getCartridgeType(value: string | number): NCartridgeType {

        if (typeof value === "number") {
            let result = value as NCartridgeType;
            if (NCartridgeType[result] === undefined) {
                return NCartridgeType.none
            }

            return result
        }
        else {
            switch (value) {
                case "W":
                    return NCartridgeType.white
                case "Y":
                    return NCartridgeType.yellow
                case "G":
                    return NCartridgeType.green
                case "B":
                    return NCartridgeType.blue
                case "P":
                    return NCartridgeType.pink
                case "L1":
                    return NCartridgeType.l1
                case "L2":
                    return NCartridgeType.l2
                case "L3":
                    return NCartridgeType.l3
                case "L4":
                    return NCartridgeType.l4
                case "L5":
                    return NCartridgeType.l5
                case "L6":
                    return NCartridgeType.l6
                case "L7":
                    return NCartridgeType.l7
                case "L8":
                    return NCartridgeType.l8
                case "m1":
                    return NCartridgeType.m1
                case "m2":
                    return NCartridgeType.m2
                case "m3":
                    return NCartridgeType.m3
                case "m4":
                    return NCartridgeType.m4
                case "m5":
                    return NCartridgeType.m5
                case "m6":
                    return NCartridgeType.m6
                case "m7":
                    return NCartridgeType.m7
                case "m8":
                    return NCartridgeType.m8
                case "?":
                    return NCartridgeType.question
                case "N":
                    return NCartridgeType.n
                default:
                    return NCartridgeType.none
            }
        }
    }
}
