#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 6.2.1 effective-5.10 (swiftlang-6.2.1.4.8 clang-1700.4.4.1)
#ifndef NEMONICSDK_SWIFT_H
#define NEMONICSDK_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef unsigned char char8_t;
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="NemonicSdk",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)

typedef SWIFT_ENUM_NAMED(NSInteger, NBatteryStatus, "NBatteryStatus", open) {
/// Normal battery level without charging.
  NBatteryStatusNoCharging = 0,
/// Low battery level for printing without charging.
  NBatteryStatusLowNoCharging = 1,
/// Normal battery level with charging.
  NBatteryStatusCharging = 2,
/// Low battery level for printing with charging.
  NBatteryStatusLowCharging = 3,
};

typedef SWIFT_ENUM_NAMED(NSInteger, NCartridgeType, "NCartridgeType", open) {
/// None.
  NCartridgeTypeNone = -1,
/// White sticky cartridge.
  NCartridgeTypeWhite = 0,
/// Yellow sticky cartridge.
  NCartridgeTypeYellow = 1,
/// Green sticky cartridge.
  NCartridgeTypeGreen = 2,
/// Blue sticky cartridge.
  NCartridgeTypeBlue = 3,
/// Pink sticky cartridge.
  NCartridgeTypePink = 7,
/// 3x1 label cartridge.
  NCartridgeTypeL1 = 13,
/// 3x2 label cartridge.
  NCartridgeTypeL2 = 12,
/// 3x3 label cartridge.
  NCartridgeTypeL3 = 10,
/// 3x4 label cartridge.
  NCartridgeTypeL4 = 6,
/// 3x5 label cartridge.
  NCartridgeTypeL5 = 8,
/// 3x6 label cartridge.
  NCartridgeTypeL6 = 5,
/// 3x7 label cartridge.
  NCartridgeTypeL7 = 9,
/// 3x8 label cartridge.
  NCartridgeTypeL8 = 11,
/// 3x1 mini cartridge.
  NCartridgeTypeM1 = 101,
/// 3x2 mini cartridge.
  NCartridgeTypeM2 = 102,
/// 3x3 mini cartridge.
  NCartridgeTypeM3 = 103,
/// 3x4 mini cartridge.
  NCartridgeTypeM4 = 104,
/// 3x5 mini cartridge.
  NCartridgeTypeM5 = 105,
/// 3x6 mini cartridge.
  NCartridgeTypeM6 = 106,
/// 3x7 mini cartridge.
  NCartridgeTypeM7 = 107,
/// 3x8 mini cartridge.
  NCartridgeTypeM8 = 108,
/// ? cartridge.
  NCartridgeTypeQuestion = 4,
/// N cartridge.
  NCartridgeTypeN = 14,
};

typedef SWIFT_ENUM_NAMED(NSInteger, NConnectState, "NConnectState", open) {
/// Disconnected state.
  NConnectStateDisconnected = 0x00,
/// Connecting state.
  NConnectStateConnecting = 0x01,
/// Connected state.
  NConnectStateConnected = 0x02,
/// Disconnecting state.
  NConnectStateDisconnecting = 0x03,
};

SWIFT_CLASS_NAMED("NPrintImageLength")
@interface NPrintImageLength : NSObject
/// Horizontal Pixels for printing.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger printWidth;)
+ (NSInteger)printWidth SWIFT_WARN_UNUSED_RESULT;
/// Maximum Pixels that can be printed at one time.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger maxLength;)
+ (NSInteger)maxLength SWIFT_WARN_UNUSED_RESULT;
/// Maximum Pixels that can be printed at one time for MIP-201(Nemonic AI).
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger maxLengthMip201;)
+ (NSInteger)maxLengthMip201 SWIFT_WARN_UNUSED_RESULT;
/// Maximum Pixels that can be set for printer templates at one time.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger maxTemplateLength;)
+ (NSInteger)maxTemplateLength SWIFT_WARN_UNUSED_RESULT;
/// Maximum Pixels that can be set for printer templates at one time for MIP-201(Nemonic AI).
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger maxTemplateLengthMip201;)
+ (NSInteger)maxTemplateLengthMip201 SWIFT_WARN_UNUSED_RESULT;
/// Vertical Pixels on 3x1 Paper.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger content1inch;)
+ (NSInteger)content1inch SWIFT_WARN_UNUSED_RESULT;
/// Vertical Pixels on 3x2 Paper.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger content2inch;)
+ (NSInteger)content2inch SWIFT_WARN_UNUSED_RESULT;
/// Vertical Pixels on 3x3 Paper.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger content3inch;)
+ (NSInteger)content3inch SWIFT_WARN_UNUSED_RESULT;
/// Vertical Pixels on 3x4 Paper.
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, readonly) NSInteger content4inch;)
+ (NSInteger)content4inch SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

@class NSString;
/// Information for printing.
SWIFT_CLASS("_TtC10NemonicSdk10NPrintInfo")
@interface NPrintInfo : NSObject
/// Get summary information for printing.
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, NPrintQuality, "NPrintQuality", open) {
/// Low quality and fast speed(Max speed: 80mm/s).
  NPrintQualityLowFast = 0,
/// Middle quality and middle speed(Max speed: 40mm/s).
  NPrintQualityMiddle = 1,
/// High quality and slow speed(Max speed: 25/s).
  NPrintQualityHighSlow = 2,
};

enum NPrinterType : NSInteger;
SWIFT_CLASS_NAMED("NPrinter")
@interface NPrinter : NSObject
/// Basic constructor.
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Constructor with name and macAddress.
/// \param name Printer Bluetooth name.
///
/// \param macAddress Printer Bluetooth Mac address.
///
- (nonnull instancetype)initWithName:(NSString * _Nonnull)name macAddress:(NSString * _Nonnull)macAddress OBJC_DESIGNATED_INITIALIZER;
/// Constructor with type, name and macAddress.
/// \param type Printer type.
///
/// \param name Printer Bluetooth name.
///
/// \param macAddress Printer Bluetooth Mac Address.
///
- (nonnull instancetype)initWithType:(enum NPrinterType)type name:(NSString * _Nonnull)name macAddress:(NSString * _Nonnull)macAddress OBJC_DESIGNATED_INITIALIZER;
/// Whether the printer information is empty.
///
/// returns:
/// Whether the printer information is empty.
- (BOOL)isEmpty SWIFT_WARN_UNUSED_RESULT;
/// Whether the printer information is a Nemonic product.
///
/// returns:
/// Whether the printer information is a Nemonic product.
- (BOOL)isValid SWIFT_WARN_UNUSED_RESULT;
/// Reset printer information.
- (void)reset;
/// Get printer Bluetooth name.
///
/// returns:
/// Printer Bluetooth name.
- (NSString * _Nonnull)getName SWIFT_WARN_UNUSED_RESULT;
/// Set printer Bluetooth name.
/// \param name Printer Bluetooth name.
///
- (void)setName:(NSString * _Nonnull)name;
/// Check printer Bluetooth name validation.
/// \param name Printer Bluetooth name.
///
///
/// returns:
/// Printer Bluetooth name valid.
- (BOOL)checkName:(NSString * _Nonnull)name SWIFT_WARN_UNUSED_RESULT;
/// Check printer Bluetooth name validation.
/// \param type Printer type.
///
/// \param name Printer Bluetooth name.
///
///
/// returns:
/// Printer Bluetooth name valid.
+ (BOOL)checkNameWithType:(enum NPrinterType)type name:(NSString * _Nonnull)name SWIFT_WARN_UNUSED_RESULT;
/// Check printer Bluetooth name without cartridge type(using setting printer name).
/// \param type Printer type.
///
/// \param name Printer Bluetooth name.
///
///
/// returns:
/// Printer Bluetooth name valid.
+ (BOOL)checkNameWithoutCartridgeTypeWithType:(enum NPrinterType)type name:(NSString * _Nonnull)name SWIFT_WARN_UNUSED_RESULT;
/// Get Mac address.
///
/// returns:
/// Mac address.
- (NSString * _Nonnull)getMacAddress SWIFT_WARN_UNUSED_RESULT;
/// Set Mac address.
/// \param macAddress Mac address.
///
- (BOOL)setMacAddress:(NSString * _Nonnull)macAddress SWIFT_WARN_UNUSED_RESULT;
/// Check Mac address valid.
/// \param macAddress Mac address.
///
///
/// returns:
/// Mac address valid.
- (BOOL)checkMacAddress:(NSString * _Nonnull)macAddress SWIFT_WARN_UNUSED_RESULT;
/// Get printer type.
///
/// returns:
/// Printer type.
- (enum NPrinterType)getType SWIFT_WARN_UNUSED_RESULT;
/// Set printer type.
/// \param type Printer type.
///
- (void)setType:(enum NPrinterType)type;
/// Whether the printer has a valid cartridge.
///
/// returns:
/// Whether the printer has a valid cartridge.
- (BOOL)hasValidCartridge SWIFT_WARN_UNUSED_RESULT;
/// Whether the printer is Nemonic mini printer.
///
/// returns:
/// Whether the printer is Nemonic mini printer.
- (BOOL)isMini SWIFT_WARN_UNUSED_RESULT;
/// Label printer or not(It does not refer to a Nemonic Label product(MIP-001L)).
///
/// returns:
/// Label printer or not.(When the result is false, it does not mean that it is not a Nemonic Label product (MIP-001L)).
- (BOOL)isLabel SWIFT_WARN_UNUSED_RESULT;
/// Whether it is a sticky cartridge type.
///
/// returns:
/// Whether it is a sticky cartridge type.
- (BOOL)isSticky SWIFT_WARN_UNUSED_RESULT;
/// Whether it is a fixed length cartridge type.
///
/// returns:
/// Whether it is a fixed length cartridge type.
- (BOOL)isFixedPaperSize SWIFT_WARN_UNUSED_RESULT;
/// Whether the printer supports batteries.
///
/// returns:
/// Whether the printer supports batteries.
- (BOOL)isSupportedBattery SWIFT_WARN_UNUSED_RESULT;
/// Whether the printer supports password.
///
/// returns:
/// Whether the printer supports password.
- (BOOL)isSupportedPassword SWIFT_WARN_UNUSED_RESULT;
/// Get cartridge type (based on printer name).
///
/// returns:
/// Cartridge type.
- (enum NCartridgeType)getCartridgeType SWIFT_WARN_UNUSED_RESULT;
/// Get print time.
/// \param height Print image height.
///
/// \param copies Print copies.
///
///
/// returns:
/// Print time (msec).
- (NSInteger)getWaitTimeForPrint:(NSInteger)height :(NSInteger)copies SWIFT_WARN_UNUSED_RESULT;
/// Whether it is the same printer (based on Mac address).
/// \param object Other NPrinter object for comparison.
///
///
/// returns:
/// Whether it is the same printer.
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
@end

@protocol NPrinterControllerDelegate;
SWIFT_CLASS_NAMED("NPrinterController")
@interface NPrinterController : NSObject
/// Basic constructor.
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Constructor using delegate
/// \param delegate Delegate object.
///
- (nonnull instancetype)init:(id <NPrinterControllerDelegate> _Nonnull)delegate OBJC_DESIGNATED_INITIALIZER;
/// Get default delay after connecting.(Only Nemonic AI printer)
///
/// returns:
/// Default delay after connecting (milly second).
- (uint32_t)getDefaultConnectDelay SWIFT_WARN_UNUSED_RESULT;
/// Get delay after connecting.(Only Nemonic AI printer)
///
/// returns:
/// Delay after connecting (milly second).
- (uint32_t)getConnectDelay SWIFT_WARN_UNUSED_RESULT;
/// Set delay after connecting.(Only Nemonic AI printer)
/// \param delay Delay after connecting (milly second).
///
- (void)setConnectDelay:(uint32_t)delay;
/// Connect the printer selecting Bluetooth mode automatically depending on the printer type.
/// \param printer Printer to connect to.
///
///
/// returns:
/// Connect result (NResult).
- (NSInteger)connect:(NPrinter * _Nonnull)printer queueLabel:(NSString * _Nullable)queueLabel SWIFT_WARN_UNUSED_RESULT;
@end

SWIFT_PROTOCOL_NAMED("NPrinterControllerDelegate")
@protocol NPrinterControllerDelegate <NSObject>
/// Called when the printer is disconnected due to external factors.
- (void)disconnected;
/// Called to notify the progress of each print image when printing multiple images.
/// \param index Current print completion index (starting from 0).
///
/// \param total Total number of printing images.
///
/// \param result Print result of the currently printed index.
///
- (void)printProgressWithIndex:(NSInteger)index total:(NSInteger)total result:(NSInteger)result;
/// Called when all printing is complete.
/// \param result Print result.
///
- (void)printCompleteWithResult:(NSInteger)result;
@end

@protocol NPrinterScanControllerDelegate;
SWIFT_CLASS_NAMED("NPrinterScanController")
@interface NPrinterScanController : NSObject
@property (nonatomic, strong) id <NPrinterScanControllerDelegate> _Nullable delegate;
/// Basic constructor.
/// \param delegate Callback object.
///
- (nonnull instancetype)init:(id <NPrinterScanControllerDelegate> _Nonnull)delegate OBJC_DESIGNATED_INITIALIZER;
/// Start scan.
///
/// returns:
/// Start scan result (NResult).
- (NSInteger)startScan SWIFT_WARN_UNUSED_RESULT;
/// Stop scan.
- (void)stopScan;
/// Whether scanning.
///
/// returns:
/// Whether scanning.
- (BOOL)isInScan SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_PROTOCOL_NAMED("NPrinterScanControllerDelegate")
@protocol NPrinterScanControllerDelegate <NSObject>
/// Called when a printer is found.
/// \param printer Printer information found.
///
- (void)deviceFound:(NPrinter * _Nonnull)printer;
@end

typedef SWIFT_ENUM_NAMED(NSInteger, NPrinterStatus, "NPrinterStatus", open) {
/// Ok.
  NPrinterStatusOk = 0,
/// Out of paper.
  NPrinterStatusOutOfPaper = 2,
/// Cover opened.
  NPrinterStatusCoverOpened = 4,
/// Overheat.
  NPrinterStatusOverheat = 8,
/// Paper jam.
  NPrinterStatusPaperJam = 16,
};

typedef SWIFT_ENUM_NAMED(NSInteger, NPrinterType, "NPrinterType", open) {
/// None.
  NPrinterTypeNone = 0,
/// Nemonic (MIP-001).
  NPrinterTypeNemonic = 1,
/// Nemonic Label (MIP-001L).
  NPrinterTypeNemonicLabel = 2,
/// Nemonic mini (MIP-101).
  NPrinterTypeNemonicMini = 3,
/// Nemonic AI (MIP-201).
  NPrinterTypeNemonicMip201 = 4,
};

typedef SWIFT_ENUM_NAMED(NSInteger, NResult, "NResult", open) {
/// Ok.
  NResultOk = 0x00,
/// Timeout.
  NResultTimeout = -64,
/// Canceled.
  NResultCanceled = -65,
/// Battery low.
  NResultBatteryLow = -70,
/// Battery needs charging.
  NResultBatteryNeedCharge = -71,
/// Paper not matched.
  NResultPaperNotMatched = -80,
/// Unavailable cartridge.
  NResultUnavailableCartridge = -81,
/// Bluetooth not supported.
  NResultBluetoothUnsupported = -100,
/// Bluetooth disabled.
  NResultBluetoothDisabled = -101,
/// No Bluetooth permission
  NResultBluetoothNoPermission = -102,
/// Bluetooth resetting.(only iOS)
  NResultBluetoothResetting = -103,
/// Bluetooth connection canceled or disabled.(only iOS)
  NResultCanceledOrBluetoothDisabled = -104,
/// Bluetooth unknown.(only iOS)
  NResultBluetoothUnknown = -105,
/// No location permission.(only Android)
  NResultLocationNoPermission = -110,
/// Location disabled.(only Android)
  NResultLocationDisabled = -111,
/// Printer scan failed.
  NResultScanFailed = -200,
/// No selected printer.
  NResultNoSelectedPrinter = -300,
/// Not connected.
  NResultNotConnected = -301,
/// Already connected.
  NResultAlreadyConnected = -302,
/// Bluetooth device not found.(only iOS)
  NResultNotFound = -303,
/// Bluetooth is not connectable.(only iOS)
  NResultNotConnectable = -304,
/// Socket error.
  NResultSocketError = -305,
/// Connect error.
  NResultConnectError = -306,
/// Connect failed.
  NResultConnectFailed = -307,
/// Session error.
  NResultSessionError = -308,
/// Connect service not found.
  NResultConnectServiceNotFound = -309,
/// Unsupported connect mode.
  NResultConnectUnsupportedMode = -310,
/// IO receive error.
  NResultIoReceiveError = -400,
/// IO send error.
  NResultIoSendError = -401,
/// Send failed.
  NResultSendFailed = -402,
/// Unknown.
  NResultUnknown = -500,
/// Invalid parameter.
  NResultInvalidParameter = -501,
/// Not matched printer type.
  NResultNotMatchedPrinterType = -502,
/// No delegate.
  NResultNoDelegate = -503,
/// Not matched printer command result format.
  NResultNotMatchedCommandResultFormat = -504,
/// Invalid printer name.
  NResultInvalidPrinterName = -505,
/// Invalid printer result.
  NResultInvalidPrinterResult = -506,
/// Printer result failed.
  NResultPrinterResultFailed = -507,
/// Unsupported device.
  NResultUnsupportedDevice = -508,
};

SWIFT_CLASS_NAMED("NResultPrintable")
@interface NResultPrintable : NSObject
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

SWIFT_CLASS_NAMED("NResultString")
@interface NResultString : NSObject
/// Basic constructor.
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

SWIFT_CLASS_NAMED("NSDKInfo")
@interface SDKInfo : NSObject
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
