enum NCartridgeType {
  none(-1),
  white(0),
  yellow(1),
  green(2),
  blue(3),
  pink(7),
  l1(13),
  l2(12),
  l3(10),
  l4(6),
  l5(8),
  l6(5),
  l7(9),
  l8(11),
  m1(101),
  m2(102),
  m3(103),
  m4(104),
  m5(105),
  m6(106),
  m7(107),
  m8(108),
  question(4),
  n(14);

  const NCartridgeType(this.code);
  final int code;

  bool get isValid {
    switch (this) {
      case NCartridgeType.white:
      case NCartridgeType.yellow:
      case NCartridgeType.green:
      case NCartridgeType.blue:
      case NCartridgeType.pink:
      case NCartridgeType.l1:
      case NCartridgeType.l2:
      case NCartridgeType.l3:
      case NCartridgeType.l4:
      case NCartridgeType.l5:
      case NCartridgeType.l6:
      case NCartridgeType.l7:
      case NCartridgeType.l8:
      case NCartridgeType.m1:
      case NCartridgeType.m2:
      case NCartridgeType.m3:
      case NCartridgeType.m4:
      case NCartridgeType.m5:
      case NCartridgeType.m6:
      case NCartridgeType.m7:
      case NCartridgeType.m8:
      case NCartridgeType.n:
        return true;
      default:
        return false;
    }
  }

  bool get isMini {
    switch (this) {
      case NCartridgeType.m1:
      case NCartridgeType.m2:
      case NCartridgeType.m3:
      case NCartridgeType.m4:
      case NCartridgeType.m5:
      case NCartridgeType.m6:
      case NCartridgeType.m7:
      case NCartridgeType.m8:
        return true;
      default:
        return false;
    }
  }

  bool get isLabel {
    switch (this) {
      case NCartridgeType.l1:
      case NCartridgeType.l2:
      case NCartridgeType.l3:
      case NCartridgeType.l4:
      case NCartridgeType.l5:
      case NCartridgeType.l6:
      case NCartridgeType.l7:
      case NCartridgeType.l8:
        return true;
      default:
        return false;
    }
  }

  bool get isSticky {
    switch (this) {
      case NCartridgeType.white:
      case NCartridgeType.yellow:
      case NCartridgeType.green:
      case NCartridgeType.blue:
      case NCartridgeType.pink:
      case NCartridgeType.m1:
      case NCartridgeType.m2:
      case NCartridgeType.m3:
      case NCartridgeType.m4:
      case NCartridgeType.m5:
      case NCartridgeType.m6:
      case NCartridgeType.m7:
      case NCartridgeType.m8:
      case NCartridgeType.n:
        return true;
      default:
        return false;
    }
  }

  factory NCartridgeType.getByCode(int code) {
    return NCartridgeType.values.firstWhere((value) => value.code == code,
        orElse: () => NCartridgeType.none);
  }

  factory NCartridgeType.fromDynamic(dynamic code) {
    if (code is NCartridgeType) {
      return code;
    } else if (code is int) {
      return NCartridgeType.getByCode(code);
    }

    return NCartridgeType.none;
  }

  factory NCartridgeType.fromPrinterName(String name) {
    String typeName = '';

    List<String> values = name.split('_');
    if (values.length >= 2) {
      typeName = values[values.length - 1];
    }

    switch (typeName) {
      case 'W':
      case 'w':
        return NCartridgeType.white;
      case 'Y':
      case 'y':
        return NCartridgeType.yellow;
      case 'G':
      case 'g':
        return NCartridgeType.green;
      case 'B':
      case 'b':
        return NCartridgeType.blue;
      case 'P':
      case 'p':
        return NCartridgeType.pink;
      case 'L1':
      case 'l1':
        return NCartridgeType.l1;
      case 'L2':
      case 'l2':
        return NCartridgeType.l2;
      case 'L3':
      case 'l3':
        return NCartridgeType.l3;
      case 'L4':
      case 'l4':
        return NCartridgeType.l4;
      case 'L5':
      case 'l5':
        return NCartridgeType.l5;
      case 'L6':
      case 'l6':
        return NCartridgeType.l6;
      case 'L7':
      case 'l7':
        return NCartridgeType.l7;
      case 'L8':
      case 'l8':
        return NCartridgeType.l8;
      case 'M1':
      case 'm1':
        return NCartridgeType.m1;
      case 'M2':
      case 'm2':
        return NCartridgeType.m2;
      case 'M3':
      case 'm3':
        return NCartridgeType.m3;
      case 'M4':
      case 'm4':
        return NCartridgeType.m4;
      case 'M5':
      case 'm5':
        return NCartridgeType.m5;
      case 'M6':
      case 'm6':
        return NCartridgeType.m6;
      case 'M7':
      case 'm7':
        return NCartridgeType.m7;
      case 'M8':
      case 'm8':
        return NCartridgeType.m8;
      case '?':
        return NCartridgeType.question;
      case 'N':
      case 'n':
        return NCartridgeType.n;
      default:
        return NCartridgeType.none;
    }
  }

  static String stringNameOf(NCartridgeType type, bool isMini) {
    switch (type) {
      case NCartridgeType.white:
        return 'W';
      case NCartridgeType.yellow:
        return 'Y';
      case NCartridgeType.green:
        return 'G';
      case NCartridgeType.blue:
        return 'B';
      case NCartridgeType.pink:
        return 'P';
      case NCartridgeType.l1:
        if (isMini) {
          return 'm1';
        }
        return 'L1';
      case NCartridgeType.l2:
        if (isMini) {
          return 'm2';
        }
        return 'L2';
      case NCartridgeType.l3:
        if (isMini) {
          return 'm3';
        }
        return 'L3';
      case NCartridgeType.l4:
        if (isMini) {
          return 'm4';
        }
        return 'L4';
      case NCartridgeType.l5:
        if (isMini) {
          return 'm5';
        }
        return 'L5';
      case NCartridgeType.l6:
        if (isMini) {
          return 'm6';
        }
        return 'L6';
      case NCartridgeType.l7:
        if (isMini) {
          return 'm7';
        }
        return 'L7';
      case NCartridgeType.l8:
        if (isMini) {
          return 'm8';
        }
        return 'L8';
      case NCartridgeType.m1:
        return 'm1';
      case NCartridgeType.m2:
        return 'm2';
      case NCartridgeType.m3:
        return 'm3';
      case NCartridgeType.m4:
        return 'm4';
      case NCartridgeType.m5:
        return 'm5';
      case NCartridgeType.m6:
        return 'm6';
      case NCartridgeType.m7:
        return 'm7';
      case NCartridgeType.m8:
        return 'm8';
      case NCartridgeType.question:
        return '?';
      case NCartridgeType.n:
        return 'N';
      default:
        return '';
    }
  }

  @override
  String toString() {
    switch (this) {
      case NCartridgeType.none:
        return 'X';
      case NCartridgeType.white:
        return 'W';
      case NCartridgeType.yellow:
        return 'Y';
      case NCartridgeType.green:
        return 'G';
      case NCartridgeType.blue:
        return 'B';
      case NCartridgeType.pink:
        return 'P';
      case NCartridgeType.l1:
        return 'L1';
      case NCartridgeType.l2:
        return 'L2';
      case NCartridgeType.l3:
        return 'L3';
      case NCartridgeType.l4:
        return 'L4';
      case NCartridgeType.l5:
        return 'L5';
      case NCartridgeType.l6:
        return 'L6';
      case NCartridgeType.l7:
        return 'L7';
      case NCartridgeType.l8:
        return 'L8';
      case NCartridgeType.m1:
        return 'm1';
      case NCartridgeType.m2:
        return 'm2';
      case NCartridgeType.m3:
        return 'm3';
      case NCartridgeType.m4:
        return 'm4';
      case NCartridgeType.m5:
        return 'm5';
      case NCartridgeType.m6:
        return 'm6';
      case NCartridgeType.m7:
        return 'm7';
      case NCartridgeType.m8:
        return 'm8';
      case NCartridgeType.question:
        return '?';
      case NCartridgeType.n:
        return 'N';
    }
  }
}
